/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 13:00:57 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "lp2hp.h"
#include "libmatlbm.h"
#include "libmmfile.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;

void InitializeModule_lp2hp(void) {
    _mxarray0_ = mclInitializeDouble(2.0);
    _mxarray1_ = mclInitializeDouble(1.0);
}

void TerminateModule_lp2hp(void) {
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mlp2hp(mxArray * * bt,
                        mxArray * * ct,
                        mxArray * * dt,
                        int nargout_,
                        mxArray * a,
                        mxArray * b,
                        mxArray * c,
                        mxArray * d,
                        mxArray * wo);

_mexLocalFunctionTable _local_function_table_lp2hp
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfLp2hp" contains the normal interface for the "lp2hp"
 * M-function from file "c:\matlab65\toolbox\signal\signal\lp2hp.m" (lines
 * 1-46). This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfLp2hp(mxArray * * bt,
                   mxArray * * ct,
                   mxArray * * dt,
                   mxArray * a,
                   mxArray * b,
                   mxArray * c,
                   mxArray * d,
                   mxArray * wo) {
    int nargout = 1;
    mxArray * at = NULL;
    mxArray * bt__ = NULL;
    mxArray * ct__ = NULL;
    mxArray * dt__ = NULL;
    mlfEnterNewContext(3, 5, bt, ct, dt, a, b, c, d, wo);
    if (bt != NULL) {
        ++nargout;
    }
    if (ct != NULL) {
        ++nargout;
    }
    if (dt != NULL) {
        ++nargout;
    }
    at = Mlp2hp(&bt__, &ct__, &dt__, nargout, a, b, c, d, wo);
    mlfRestorePreviousContext(3, 5, bt, ct, dt, a, b, c, d, wo);
    if (bt != NULL) {
        mclCopyOutputArg(bt, bt__);
    } else {
        mxDestroyArray(bt__);
    }
    if (ct != NULL) {
        mclCopyOutputArg(ct, ct__);
    } else {
        mxDestroyArray(ct__);
    }
    if (dt != NULL) {
        mclCopyOutputArg(dt, dt__);
    } else {
        mxDestroyArray(dt__);
    }
    return mlfReturnValue(at);
}

/*
 * The function "mlxLp2hp" contains the feval interface for the "lp2hp"
 * M-function from file "c:\matlab65\toolbox\signal\signal\lp2hp.m" (lines
 * 1-46). The feval function calls the implementation version of lp2hp through
 * this function. This function processes any input arguments and passes them
 * to the implementation version of the function, appearing above.
 */
void mlxLp2hp(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[5];
    mxArray * mplhs[4];
    int i;
    if (nlhs > 4) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: lp2hp Line: 1 Column: 1 The function \"lp2hp"
            "\" was called with more than the declared number of outputs (4)."),
          NULL);
    }
    if (nrhs > 5) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: lp2hp Line: 1 Column: 1 The function \"lp2hp"
            "\" was called with more than the declared number of inputs (5)."),
          NULL);
    }
    for (i = 0; i < 4; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 5 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 5; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    mplhs[0]
      = Mlp2hp(
          &mplhs[1],
          &mplhs[2],
          &mplhs[3],
          nlhs,
          mprhs[0],
          mprhs[1],
          mprhs[2],
          mprhs[3],
          mprhs[4]);
    mlfRestorePreviousContext(
      0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 4 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 4; ++i) {
        mxDestroyArray(mplhs[i]);
    }
}

/*
 * The function "Mlp2hp" is the implementation version of the "lp2hp"
 * M-function from file "c:\matlab65\toolbox\signal\signal\lp2hp.m" (lines
 * 1-46). It contains the actual compiled code for that M-function. It is a
 * static function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [at,bt,ct,dt] = lp2hp(a,b,c,d,wo)
 */
static mxArray * Mlp2hp(mxArray * * bt,
                        mxArray * * ct,
                        mxArray * * dt,
                        int nargout_,
                        mxArray * a,
                        mxArray * b,
                        mxArray * c,
                        mxArray * d,
                        mxArray * wo) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_lp2hp);
    int nargin_ = mclNargin(5, a, b, c, d, wo, NULL);
    mxArray * at = NULL;
    mxArray * den = NULL;
    mxArray * num = NULL;
    mxArray * k = NULL;
    mxArray * z = NULL;
    mxArray * mc = NULL;
    mxArray * nb = NULL;
    mxArray * ma = NULL;
    mxArray * ans = NULL;
    mclCopyArray(&a);
    mclCopyArray(&b);
    mclCopyArray(&c);
    mclCopyArray(&d);
    mclCopyArray(&wo);
    /*
     * %LP2HP Lowpass to highpass analog filter transformation.
     * %   [NUMT,DENT] = LP2HP(NUM,DEN,Wo) transforms the lowpass filter
     * %   prototype NUM(s)/DEN(s) with unity cutoff frequency to a
     * %   highpass filter with cutoff frequency Wo.
     * %   [AT,BT,CT,DT] = LP2HP(A,B,C,D,Wo) does the same when the
     * %   filter is described in state-space form.
     * %
     * %   See also BILINEAR, IMPINVAR, LP2BP, LP2BS and LP2LP
     * 
     * %   Author(s): J.N. Little and G.F. Franklin, 8-4-87
     * %   Copyright 1988-2002 The MathWorks, Inc.
     * %   $Revision: 1.7 $  $Date: 2002/03/28 17:28:44 $
     * 
     * if nargin == 3		% Transfer function case
     */
    if (nargin_ == 3) {
        /*
         * % handle column vector inputs: convert to rows
         * if size(a,2) == 1
         */
        if (mclEqBool(
              mlfSize(mclValueVarargout(), mclVa(a, "a"), _mxarray0_),
              _mxarray1_)) {
            /*
             * a = a(:).';
             */
            mlfAssign(
              &a,
              mlfTranspose(mclArrayRef1(mclVa(a, "a"), mlfCreateColonIndex())));
        /*
         * end
         */
        }
        /*
         * if size(b,2) == 1
         */
        if (mclEqBool(
              mlfSize(mclValueVarargout(), mclVa(b, "b"), _mxarray0_),
              _mxarray1_)) {
            /*
             * b = b(:).';
             */
            mlfAssign(
              &b,
              mlfTranspose(mclArrayRef1(mclVa(b, "b"), mlfCreateColonIndex())));
        /*
         * end
         */
        }
        /*
         * % Transform to state-space
         * wo = c;
         */
        mlfAssign(&wo, mclVa(c, "c"));
        /*
         * [a,b,c,d] = tf2ss(a,b);
         */
        mlfAssign(&a, mlfTf2ss(&b, &c, &d, mclVa(a, "a"), mclVa(b, "b")));
    /*
     * end
     */
    }
    /*
     * 
     * error(abcdchk(a,b,c,d));
     */
    mlfError(
      mlfAbcdchk(
        NULL,
        NULL,
        NULL,
        NULL,
        mclVa(a, "a"),
        mclVa(b, "b"),
        mclVa(c, "c"),
        mclVa(d, "d")),
      NULL);
    /*
     * [ma,nb] = size(b);
     */
    mlfSize(mlfVarargout(&ma, &nb, NULL), mclVa(b, "b"), NULL);
    /*
     * [mc,ma] = size(c);
     */
    mlfSize(mlfVarargout(&mc, &ma, NULL), mclVa(c, "c"), NULL);
    /*
     * 
     * % Transform lowpass to highpass
     * at =  wo*inv(a);
     */
    mlfAssign(&at, mclMtimes(mclVa(wo, "wo"), mlfInv(mclVa(a, "a"))));
    /*
     * bt = -wo*(a\b);
     */
    mlfAssign(
      bt,
      mclMtimes(
        mclUminus(mclVa(wo, "wo")), mlfMldivide(mclVa(a, "a"), mclVa(b, "b"))));
    /*
     * ct = c/a;
     */
    mlfAssign(ct, mclMrdivide(mclVa(c, "c"), mclVa(a, "a")));
    /*
     * dt = d - c/a*b;
     */
    mlfAssign(
      dt,
      mclMinus(
        mclVa(d, "d"),
        mclMtimes(mclMrdivide(mclVa(c, "c"), mclVa(a, "a")), mclVa(b, "b"))));
    /*
     * 
     * if nargin == 3		% Transfer function case
     */
    if (nargin_ == 3) {
        /*
         * % Transform back to transfer function
         * [z,k] = tzero(at,bt,ct,dt);
         */
        mlfAssign(
          &z,
          mlfNTzero(
            2,
            &k,
            mclVv(at, "at"),
            mclVv(*bt, "bt"),
            mclVv(*ct, "ct"),
            mclVv(*dt, "dt")));
        /*
         * num = k * poly(z);
         */
        mlfAssign(&num, mclMtimes(mclVv(k, "k"), mlfPoly(mclVv(z, "z"))));
        /*
         * den = poly(at);
         */
        mlfAssign(&den, mlfPoly(mclVv(at, "at")));
        /*
         * at = num;
         */
        mlfAssign(&at, mclVv(num, "num"));
        /*
         * bt = den;
         */
        mlfAssign(bt, mclVv(den, "den"));
    /*
     * end
     */
    }
    mclValidateOutput(at, 1, nargout_, "at", "lp2hp");
    mclValidateOutput(*bt, 2, nargout_, "bt", "lp2hp");
    mclValidateOutput(*ct, 3, nargout_, "ct", "lp2hp");
    mclValidateOutput(*dt, 4, nargout_, "dt", "lp2hp");
    mxDestroyArray(ans);
    mxDestroyArray(ma);
    mxDestroyArray(nb);
    mxDestroyArray(mc);
    mxDestroyArray(z);
    mxDestroyArray(k);
    mxDestroyArray(num);
    mxDestroyArray(den);
    mxDestroyArray(wo);
    mxDestroyArray(d);
    mxDestroyArray(c);
    mxDestroyArray(b);
    mxDestroyArray(a);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return at;
}
